package com.example.android.vpntest;

import android.app.IntentService;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.VpnService;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiManager;
import android.os.AsyncTask;
import android.os.Environment;
import android.os.IBinder;
import android.provider.Settings;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.CheckBox;
import android.widget.TextView;
import android.widget.Toast;
import android.widget.ToggleButton;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;

/**
 * Provides the Graphical interface for the whole application.
 * @author Steven Schalhorn
 * @version 1.0
 */
public class MainActivity extends AppCompatActivity {

    private static final String TAG = "VPN";
    private static SharedPreferences sharedPref;
    private Integer[] checkboxes = {
            R.id.ad,
            R.id.gambling,
            R.id.malware,
            R.id.phishing,
            R.id.porn,
            R.id.privacy,
            R.id.social
    };

    boolean bound = false;
    UserVpnService boundVpn;

    /**
     * Constructs the interface and sets the category buttons to the saved values.
     *
     * {@inheritDoc}
     * @param savedInstanceState
     */
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Log.i(TAG, "maxmemory: " + Runtime.getRuntime().maxMemory());
        setContentView(R.layout.activity_main);
        sharedPref = getSharedPreferences("VPN", Context.MODE_PRIVATE);

        // Checkbox states
        for (Integer checkbox : checkboxes) {
            boolean checkboxState = sharedPref.getBoolean(checkbox.toString(), true);
            CheckBox checkBoxView = findViewById(checkbox);
            checkBoxView.setChecked(checkboxState);
        }

        ToggleButton startStopButton = findViewById(R.id.button);
        startStopButton.setChecked(UserVpnService.serviceRunning); // Set to state of VPN-Service

        if (UserVpnService.serviceRunning) {
            Intent intent = new Intent(this, UserVpnService.class);
            bindService(intent, connection, Context.BIND_AUTO_CREATE);
        }

        // Network Information Text
        //TextView netinfoView = (TextView) findViewById(R.id.network_info_text);
        //String netinfo = netinfo();
        //if (netinfo.contains("SSID")) {
        //    netinfo = "Wifi[" + netinfo.split("\"")[1] + "]";
        //} else if (netinfo.contains("MOBILE")) {
        //    netinfo = netinfo.split("\\s+|,")[1];
        //}
        //netinfoView.setText(netinfo);
    }

    /**
     * Sets the service status on the button even when the app is opened during disconnect dialog
     *
     * {@inheritDoc}
     */
    @Override
    protected void onResume() {
        //
        ToggleButton startStopButton = findViewById(R.id.button);
        startStopButton.setChecked(UserVpnService.serviceRunning); // Set to state of VPN-Service
        super.onResume();
    }

    /**
     * Cleanly cuts the connection to the running service
     *
     * {@inheritDoc}
     */
    @Override
    protected void onDestroy() {
        Intent intent = new Intent(this, UserVpnService.class);
        unbindService(connection);
        super.onDestroy();
    }

    /**
     * Starts or stops the service depending on the current status.
     * @param view Toggle button to set the status text
     */
    public void toggleVpn(View view) {
        if (UserVpnService.serviceRunning == false) {
            Log.i(TAG, "toggleVpn: Starting Service");
            Intent intent = VpnService.prepare(getApplicationContext());
            if (intent != null) {
                startActivityForResult(intent, 0);
            } else {
                onActivityResult(0, RESULT_OK, null);
            }
        } else {
            Log.i(TAG, "toggleVpn: Stopping Service");
            boundVpn.stopVpn();
        }
    }

    /**
     * Starts the service and binds to it for lather communication
     *
     * {@inheritDoc}
     * @param requestCode
     * @param resultCode
     * @param data
     */
    @Override
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        if (resultCode == RESULT_OK) {
            Intent intent = new Intent(this, UserVpnService.class);
            intent.putIntegerArrayListExtra("categories", new ArrayList<Integer>(Arrays.asList(checkboxes)));
            startService(intent);
            bindService(intent, connection, Context.BIND_AUTO_CREATE);
        }
    }

    /**
     * Stores the state of the given checkbox.
     * @param view Checkbox in the ui to get the status from
     */
    public void categoryCheckboxClicked(View view) {
        boolean checkBoxstate = ((CheckBox) view).isChecked();
        sharedPref.edit()
                .putBoolean(Integer.toString(view.getId()), checkBoxstate)
                .commit();

        if (bound) {
            String categoryName = getResources().getResourceEntryName(view.getId()); // get id name of resource integer
            boundVpn.changeCategory(categoryName, checkBoxstate);
        }
    }

    /**
     * Callback for service binding.
     */
    private ServiceConnection connection = new ServiceConnection() {
        /**
         * Saves the communication interface and sets the bound state to true
         *
         * {@inheritDoc}
         * @param name
         * @param service
         */
        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            UserVpnService.UserVpnBinder binder = (UserVpnService.UserVpnBinder) service;
            boundVpn = binder.getService();
            bound = true;
        }

        /**
         * Sets the bound state to false.
         * @param name
         */
        @Override
        public void onServiceDisconnected(ComponentName name) {
            bound = false;
        }
    };

    //public void send_package(View view) {
    //    new DownloadFileFromURL().execute();
    //}

    //public void dns_request(View view) {
    //    new DnsRequest().execute("milch.de");
    //}

    //public void netinfo_toast(View view) {
    //    String netinfo = netinfo();
    //    if (netinfo.equals("")) {
    //        Toast.makeText(this, "offline", Toast.LENGTH_LONG).show();
    //    } else {
    //        Toast.makeText(this, netinfo(), Toast.LENGTH_LONG).show();
    //    }
    //}

    //public String netinfo() {
    //    String outinfo = "";
    //    ConnectivityManager cm = (ConnectivityManager) getApplicationContext()
    //            .getSystemService(Context.CONNECTIVITY_SERVICE);

    //    NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
    //    if (activeNetwork == null) {
    //        outinfo = "";
    //    } else if (activeNetwork.isConnected()) {
    //        //Toast.makeText(this, activeNetwork.toString(), Toast.LENGTH_LONG).show();
    //        outinfo = activeNetwork.toString();
    //        Log.i(TAG, "netinfo: " + activeNetwork.toString());

    //        WifiManager wifiManager = (WifiManager) getApplicationContext().getSystemService(Context.WIFI_SERVICE);
    //        Log.i(TAG, "netinfo: " + wifiManager.getConnectionInfo());
    //        Log.i(TAG, "netinfo: " + wifiManager.getConnectionInfo().getNetworkId());
    //        //Toast.makeText(this, wifiManager.getConfiguredNetworks().toString(), Toast.LENGTH_LONG).show();
    //        //Log.i(TAG, "netinfo: " + wifiManager.getConfiguredNetworks().toString());

    //        for (WifiConfiguration wifiConfiguration : wifiManager.getConfiguredNetworks()) {
    //            if (wifiConfiguration.networkId == wifiManager.getConnectionInfo().getNetworkId()) {
    //                Log.i(TAG, "netinfo: " + wifiConfiguration);
    //                outinfo = wifiConfiguration.toString();
    //                break;
    //            }
    //        }
    //    }

    //    return outinfo;
    //}

    //public void open_connections(View view) {
    //    try {
    //        File connfile = new File("/proc/net/udp");
    //        BufferedReader reader = new BufferedReader(new FileReader(connfile));
    //        String line = "";
    //        // sl   local_address   rem_address     st    tx_queue           rx_queue       tr          tm->when    retrnsmt    uid     timeout inode
    //        // 0:   02E8A8C0:AFAE   4416D9AC:01BB   08    00000000:00000115  00:00000000    00000000    10030       0           3368623 1 00000000 23 4 22 10 -1
    //        boolean firstline = true;
    //        while ((line = reader.readLine()) != null) {
    //            if (firstline) {
    //                firstline = false;
    //                continue;
    //            }
    //            String[] fields = line.split("\\s+|:");
    //            //Log.i(TAG, "connection: " + Arrays.toString(fields));
    //            String localport = fields[4];
    //            String uid = fields[13];
    //            Log.i(TAG, "open_connections: " + Integer.parseInt(localport, 16) + " -- " + uid);
    //        }
    //    } catch (FileNotFoundException e) {
    //        e.printStackTrace();
    //    } catch (IOException e) {
    //        e.printStackTrace();
    //    }
    //}

    //class DnsRequest extends AsyncTask<String, String, String> {
    //    @Override
    //    protected String doInBackground(String... strings) {
    //        InetAddress addr = null;
    //        try {
    //            addr = InetAddress.getByName(strings[0]);
    //        } catch (UnknownHostException e) {
    //            e.printStackTrace();
    //        }
    //        return addr != null ? addr.toString() : "NOT AVAILABLE";
    //    }

    //    @Override
    //    protected void onPostExecute(String addr) {
    //        Log.i(TAG, "dns_request: " + addr);
    //    }
    //}

    //class DownloadFileFromURL extends AsyncTask<String, String, String> {

    //    /**
    //     * Downloading file in background thread
    //     * */
    //    @Override
    //    protected String doInBackground(String... f_url) {
    //        // Output stream
    //        StringBuffer sb = new StringBuffer();
    //        int count;

    //        try {
    //            //URL url = new URL(f_url[0]);
    //            URL url = new URL("http", "192.168.1.10", 8000, "/");
    //            URLConnection conection = url.openConnection();
    //            Log.i(TAG, "doInBackground: will be connecting");
    //            conection.connect();
    //            Log.i(TAG, "doInBackground: have connected");

    //            // this will be useful so that you can show a tipical 0-100%
    //            // progress bar
    //            int lenghtOfFile = conection.getContentLength();

    //            // download the file
    //            InputStream input = new BufferedInputStream(url.openStream(), 8192);

    //            byte data[] = new byte[1024];

    //            long total = 0;

    //            while ((count = input.read(data)) != -1) {
    //                total += count;
    //                sb.append(new String(data));
    //            }

    //        } catch (Exception e) {
    //            Log.e("tcp Error: ", e.getMessage());
    //        }

    //        return sb.toString();
    //    }

        /**
         * After completing background task Dismiss the progress dialog
         * **/
    //    @Override
    //    protected void onPostExecute(String output) {
    //        Log.i(TAG, "onPostExecute: " + output);
    //        Toast.makeText(getApplicationContext(), output, Toast.LENGTH_LONG).show();
    //    }

    //}
}
