package com.example.android.vpntest;

import java.util.Arrays;

/**
 * Provides a defined way to parse and interact with HTTP header information.
 * @author Steven Schalhorn
 * @version 1.0
 */
public class HttpHeader {
    private static final byte[] getRequest = new byte[]{ 0x47, 0x45, 0x54, 0x20, 0x2f}; // "GET /"
    private String host;
    private String path;

    /**
     * Constructs an object from the given header.
     * @param header byte data to parse for a HTTP header
     * @throws HttpHeaderParseError
     */
    public HttpHeader(byte[] header) throws HttpHeaderParseError {
        if (!isHttpHeader(header)) {
            throw new HttpHeaderParseError();
        }

        String sheader = new String(header);
        String[] entries = sheader.split("\r\n");
        for (String entry : entries) {
            String[] kv;
            if (entry.startsWith("GET /")) {
                kv = entry.split(" ");
            } else {
                kv = entry.split(": ", 2);
            }

            if (kv[0].equals("GET")) {
                path = kv[1];
            } else if (kv[0].equals("Host")) {
                host = kv[1];
            }
        }
    }

    /**
     * Checks whether the given bytes form a HTTP-GET header
     * @param header byte data to parse the information from
     * @return
     */
    private boolean isHttpHeader(byte[] header) {
        return getRequest[0] == header[0]
                && getRequest[1] == header[1]
                && getRequest[2] == header[2]
                && getRequest[3] == header[3]
                && getRequest[4] == header[4];
    }

    /**
     * Returns the full URL of the requested resource
     * @return String of an URL
     */
    public String getUrl() {
        return host + path;
    }

    /**
     * Returns the host part of the requested resource
     * @return
     */
    public String getHost() {
        return host;
    }

    /**
     * Retuns the path part of the requested resource
     * @return
     */
    public String getPath() {
        return path;
    }
}
